/**
 * 
 */
package com.ejie.ab18a.utilidades;

import java.util.Iterator;

import javax.xml.rpc.soap.SOAPFaultException;
import javax.xml.soap.Detail;
import javax.xml.soap.DetailEntry;
import javax.xml.soap.MessageFactory;
import javax.xml.soap.Name;
import javax.xml.soap.SOAPBody;
import javax.xml.soap.SOAPBodyElement;
import javax.xml.soap.SOAPConnection;
import javax.xml.soap.SOAPConnectionFactory;
import javax.xml.soap.SOAPElement;
import javax.xml.soap.SOAPEnvelope;
import javax.xml.soap.SOAPException;
import javax.xml.soap.SOAPFault;
import javax.xml.soap.SOAPMessage;
import javax.xml.soap.SOAPPart;


import com.ejie.ab18a.log.Ab18aLog;
import com.ejie.ab18a.properties.Ab18aPropertiesBatchManager;

/**
 * @author XXXX
 *
 */
public class Ab18aWSUtils {
	public static String llamarWS(String targetNameSpace, String url_jws, String method, String[] params,
			String[] values) throws SOAPFaultException, Exception {

		Ab18aLog.debug(Ab18aWSUtils.class.getName(), "llamarWS", "Inicio llamarWS", 1);
		Ab18aLog.debug(Ab18aWSUtils.class.getName(), "llamarWS", "url_jws: " + url_jws, 1);
		Ab18aLog.debug(Ab18aWSUtils.class.getName(), "llamarWS", "method: " + method, 1);
		Ab18aLog.debug(Ab18aWSUtils.class.getName(), "llamarWS", "params: " + params, 1);
		Ab18aLog.debug(Ab18aWSUtils.class.getName(), "llamarWS", "values: " + values, 1);
		
		SOAPMessage response = null;
		try {
			// Creamos el mensaje SOAP
			MessageFactory mfactory = MessageFactory.newInstance();
			SOAPMessage message = mfactory.createMessage();
			
			Ab18aLog.debug(Ab18aWSUtils.class.getName(), "llamarWS", "Mensaje creado", 1);
			
			// Conseguimos la parte SOAP del mensaje
			SOAPPart soapPart = message.getSOAPPart();
			SOAPEnvelope envelope = soapPart.getEnvelope();
			SOAPBody body = envelope.getBody();
			Ab18aLog.debug(Ab18aWSUtils.class.getName(), "llamarWS", "Body creado", 1);
			
			// conseguimos el tsname del metodo que vamos a invocar.
			Name name = envelope.createName(method, Ab18aPropertiesBatchManager.getProperty("webservice.name"), targetNameSpace);
			
			Ab18aLog.debug(Ab18aWSUtils.class.getName(), "llamarWS", "Tsname del metodo: " + name.getLocalName(), 1);
			
			SOAPBodyElement element = body.addBodyElement(name);
			
			if (params != null && values != null) {
				for (int i = 0; i < params.length && i < values.length; i++) {
					Ab18aLog.debug(Ab18aWSUtils.class.getName(), "llamarWS", "params["+i+"]: " + params[i], 1);
					Ab18aLog.debug(Ab18aWSUtils.class.getName(), "llamarWS", "values["+i+"]: " + values[i], 1);
					SOAPElement param = element.addChildElement(envelope.createName(params[i]));
					param.addTextNode(values[i]);	
				}
			}
			
			// Conseguimos una conexion SOAP
			SOAPConnectionFactory factory = SOAPConnectionFactory.newInstance();
			SOAPConnection con = factory.createConnection();

			Ab18aLog.debug(Ab18aWSUtils.class.getName(), "llamarWS", "Conexion creada", 1);
			// Hacemos la llamada SOAP y recuperamos la respuesta
			response = con.call(message, url_jws);
		} catch (SOAPException e) {
			Ab18aLog.error(Ab18aWSUtils.class.getName(), "llamarWS", "Error al crear la llamada de SOAP " + e, 1);
			throw e;
		} catch (Exception e) {
			Ab18aLog.error(Ab18aWSUtils.class.getName(), "llamarWS", "Error al crear la llamada de SOAP " + e, 1);
			throw e;
		}

		// Miramos si ha ido bien la ejecucion de la llamada y si es as� lo
		// pasamos a String.
		Ab18aLog.debug(Ab18aWSUtils.class.getName(), "llamarWS", "Llamada realizada " + _getResultSOAP(response), 1);
		return _getResultSOAP(response);
	}

	private static String _getResultSOAP(SOAPMessage response) throws SOAPFaultException, Exception {
		StringBuffer rtdo = new StringBuffer(100);

		SOAPBodyElement soapBodyElement = _getSOAPBodyElement(response);
		if (soapBodyElement instanceof SOAPFault) {
			SOAPFault fault = (SOAPFault) soapBodyElement;
			_tratarSOAPFault(fault);
		} else {
			// Todo ha ido OK, recogemos el resultado
			Iterator iterator = soapBodyElement.getChildElements();
			while (iterator.hasNext()) {
				Object obj = iterator.next();
				if (obj instanceof SOAPElement) {
					SOAPElement element = (SOAPElement) obj;
					rtdo.append(element.getValue());
				}
			}
		}
		return rtdo.toString();
	}

	private static SOAPBodyElement _getSOAPBodyElement(SOAPMessage response) throws SOAPException {
		SOAPBodyElement rtdo = null;
		Iterator iterator = response.getSOAPPart().getEnvelope().getBody().getChildElements();
		while (iterator.hasNext()) {
			Object oUndefined = iterator.next();
			if (oUndefined instanceof SOAPBodyElement) {
				rtdo = (SOAPBodyElement) oUndefined;
				break;
			}
		}
		return rtdo;
	}

	private static void _tratarSOAPFault(SOAPFault fault) throws Exception {
		StringBuffer mensajeError = new StringBuffer(44);
		mensajeError.append("SOAPFault:\n");
		mensajeError.append(fault.getFaultActor());
		mensajeError.append("  faultCode: ");
		mensajeError.append(fault.getFaultCode());
		mensajeError.append("\n");
		mensajeError.append("  faultString: ");
		mensajeError.append(fault.getFaultString());
		mensajeError.append("\n");
		Detail detail = fault.getDetail();
		StringBuffer detailValue = new StringBuffer(17);
		if (detail != null && detail.getDetailEntries() != null) {
			Iterator it = detail.getDetailEntries();
			while (it.hasNext()) {
				DetailEntry detailEntry = (DetailEntry) it.next();
				detailValue.append("  detailEntry: " + detailEntry.getValue() + "\n");
			}
		}
		mensajeError.append(fault.toString());
		Ab18aLog.error(Ab18aWSUtils.class.getName(), "_tratarSOAPFault", "Error en la respuesta de SOAP: " + mensajeError.toString(), 1);
		throw new Exception(mensajeError.toString());
	}
}
